#!/bin/bash
#set -e

echo
echo "********************************************************************"
echo "*  Controladores para el computador VIT-A3310                 *"
echo "*                                  para Canaima GNU/Linux 4.0	 *"
echo "*                                                                  *"
echo "********************************************************************"
echo
#export LC_ALL=C
unset LANG
if [ "$UID" != "0" ]; then
	echo
	echo "Error: Debe ejecutar esta aplicación como administrador (root)."
	echo "Abortando..."
	exit 3
fi

cd "`dirname $0`"
TOP_PATH="`pwd`"
REPO_PATH="$TOP_PATH/controladores"
SOURCES_LIST="$REPO_PATH/sources.list"


APT_OPTIONS="-y --allow-unauthenticated -o Dir::Etc::SourceList=$SOURCES_LIST"

echo "deb file://$REPO_PATH canaima/" > "$SOURCES_LIST"

apt-get clean

apt-get $APT_OPTIONS update

apt-get $APT_OPTIONS install synaptic linux-image-3.13.1 linux-headers-3.13.1 xserver-xorg-video-intel libgl1-mesa-dri libgl1-mesa-glx firmware-ralink firmware-realtek build-essential 
echo
echo "***********************************************************"
echo "*  La instalación ha terminado 			        *"
echo "*                                                         *"
echo "*  Su equipo ya se encuentra actualizado                  *"
echo "*                                                         *"
echo "*  El equipo se reiniciara automaticamante...             *"
echo "***********************************************************"
echo
sleep 10

reboot

